import FormData from 'form-data'
import strapiHelper from "../../../../../utils/strapiHelper"

export default defineEventHandler(async (event) => {
  let data: any = {}
  const body = await readBody(event)
  const id = getRouterParam(event, 'id')

  const formData = new FormData()
  formData.append('field', body.field)
  formData.append('ref', body.ref)
  formData.append('refId', body.refId)
  formData.append('files', body.files)
  formData.append('fileInfo', body.fileInfo)

  try {
    const res: any = await strapiHelper(event, `upload`, 'POST', formData)
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  } catch(error: any) {
    data = {
      status: error.status || error.statusCode || 500,
      message: error.detail || error.message || error.statusMessage
    }
  }

  return data
})